<?php require_once '../config/config.php'; ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitud de Certificado de Residencia</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <style>
        :root {
            --primary-color: #0066cc;
            --secondary-color: #28a745;
            --danger-color: #dc3545;
        }
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 40px 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .main-container {
            max-width: 900px;
            margin: 0 auto;
        }
        .header-card {
            background: white;
            border-radius: 15px 15px 0 0;
            padding: 30px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            text-align: center;
            border-bottom: 4px solid var(--primary-color);
        }
        .header-card h1 {
            color: var(--primary-color);
            font-weight: 700;
            margin-bottom: 10px;
        }
        .form-card {
            background: white;
            border-radius: 0 0 15px 15px;
            padding: 40px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        .section-title {
            color: var(--primary-color);
            font-weight: 600;
            border-bottom: 2px solid var(--primary-color);
            padding-bottom: 10px;
            margin-bottom: 25px;
        }
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.2rem rgba(0, 102, 204, 0.25);
        }
        .btn-submit {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            padding: 15px 40px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            border-radius: 50px;
        }
        .btn-submit:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        .file-input-wrapper {
            position: relative;
            overflow: hidden;
            display: inline-block;
            width: 100%;
        }
        .file-input-wrapper input[type=file] {
            position: absolute;
            left: -9999px;
        }
        .file-input-label {
            display: block;
            padding: 12px 20px;
            background-color: #f8f9fa;
            border: 2px dashed #dee2e6;
            border-radius: 8px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s;
        }
        .file-input-label:hover {
            background-color: #e9ecef;
            border-color: var(--primary-color);
        }
        .file-list {
            margin-top: 15px;
        }
        .file-item {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 10px;
            background-color: #f8f9fa;
            border-radius: 5px;
            margin-bottom: 8px;
        }
        .file-item .file-name {
            flex: 1;
            font-size: 14px;
        }
        .file-item .file-size {
            font-size: 12px;
            color: #6c757d;
            margin: 0 10px;
        }
        .btn-remove-file {
            background: none;
            border: none;
            color: var(--danger-color);
            cursor: pointer;
            padding: 5px 10px;
        }
        .info-box {
            background-color: #e7f3ff;
            border-left: 4px solid var(--primary-color);
            padding: 15px;
            margin-bottom: 25px;
            border-radius: 5px;
        }
        .required-field::after {
            content: " *";
            color: var(--danger-color);
        }
        .footer-links {
            text-align: center;
            margin-top: 30px;
        }
        .footer-links a {
            color: white;
            text-decoration: none;
            margin: 0 15px;
            font-weight: 500;
        }
        .footer-links a:hover {
            text-decoration: underline;
        }
        .success-message {
            display: none;
            background: white;
            border-radius: 15px;
            padding: 40px;
            text-align: center;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }
        .success-message i {
            font-size: 80px;
            color: var(--secondary-color);
            margin-bottom: 20px;
        }
        .loading-overlay {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0,0,0,0.7);
            z-index: 9999;
            justify-content: center;
            align-items: center;
        }
        .loading-overlay.active {
            display: flex;
        }
        .spinner-border {
            width: 3rem;
            height: 3rem;
        }
    </style>
</head>
<body>
    <div class="loading-overlay" id="loadingOverlay">
        <div class="text-center">
            <div class="spinner-border text-light" role="status"></div>
            <p class="text-white mt-3">Procesando solicitud...</p>
        </div>
    </div>

    <div class="container main-container">
        <div class="header-card">
            <i class="fas fa-home-lg-alt fa-3x text-primary mb-3"></i>
            <h1>Municipalidad de Loncoche</h1>
            <h4 class="text-muted">Solicitud de Certificado de Residencia</h4>
            <p class="mb-0">Complete el formulario para solicitar su certificado</p>
        </div>

        <div class="form-card" id="formContainer">
            <div class="info-box">
                <i class="fas fa-info-circle me-2"></i>
                <strong>Importante:</strong> Todos los campos marcados con (*) son obligatorios. 
                El certificado será enviado a su correo electrónico una vez procesado.
            </div>

            <form id="solicitudForm" enctype="multipart/form-data">
                <!-- Datos Personales -->
                <h5 class="section-title"><i class="fas fa-user me-2"></i>Datos Personales</h5>
                
                <div class="row mb-3">
                    <div class="col-md-8">
                        <label class="form-label required-field">Nombre Completo</label>
                        <input type="text" class="form-control" name="nombre_completo" required
                               placeholder="Ingrese su nombre completo">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label required-field">RUT</label>
                        <input type="text" class="form-control" name="rut" required
                               placeholder="12.345.678-9" id="rutInput">
                        <small class="text-muted">Sin puntos, con guión</small>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label required-field">Dirección Completa</label>
                    <textarea class="form-control" name="direccion" rows="2" required
                              placeholder="Calle, número, villa/población"></textarea>
                </div>

                <div class="row mb-4">
                    <div class="col-md-6">
                        <label class="form-label required-field">Teléfono</label>
                        <input type="tel" class="form-control" name="telefono" required
                               placeholder="+56 9 1234 5678">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label required-field">Correo Electrónico</label>
                        <input type="email" class="form-control" name="email" required
                               placeholder="correo@ejemplo.com">
                    </div>
                </div>

                <!-- Motivo de la Solicitud -->
                <h5 class="section-title"><i class="fas fa-file-alt me-2"></i>Información de la Solicitud</h5>
                
                <div class="mb-4">
                    <label class="form-label required-field">Motivo de la Solicitud</label>
                    <textarea class="form-control" name="motivo" rows="3" required
                              placeholder="Indique el motivo por el cual solicita el certificado (ej: trámites bancarios, postulación a beneficios, etc.)"></textarea>
                </div>

                <!-- Archivos Adjuntos -->
                <h5 class="section-title"><i class="fas fa-paperclip me-2"></i>Documentos Adjuntos (Opcional)</h5>
                
                <div class="mb-3">
                    <div class="file-input-wrapper">
                        <input type="file" name="adjuntos[]" id="fileInput" multiple 
                               accept=".pdf,.jpg,.jpeg,.png">
                        <label class="file-input-label" for="fileInput">
                            <i class="fas fa-cloud-upload-alt fa-2x mb-2"></i>
                            <p class="mb-0">Haga clic aquí para seleccionar archivos</p>
                            <small class="text-muted">Formatos permitidos: PDF, JPG, PNG (Máx. 5MB por archivo)</small>
                        </label>
                    </div>
                    <div class="file-list" id="fileList"></div>
                </div>

                <!-- reCAPTCHA -->
                <div class="mb-4 text-center">
                    <div class="g-recaptcha" data-sitekey="6LeIxAcTAAAAAJcZVRqyHh71UMIEGNQ_MXjiZKhI"></div>
                    <small class="text-muted d-block mt-2">
                        Para desarrollo: usar site key de prueba de Google
                    </small>
                </div>

                <!-- Términos y Condiciones -->
                <div class="mb-4">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="terminos" required>
                        <label class="form-check-label" for="terminos">
                            Declaro que los datos proporcionados son verdaderos y estoy de acuerdo con el 
                            procesamiento de mis datos personales para la emisión del certificado solicitado.
                        </label>
                    </div>
                </div>

                <!-- Botones -->
                <div class="text-center">
                    <button type="submit" class="btn btn-primary btn-submit">
                        <i class="fas fa-paper-plane me-2"></i>Enviar Solicitud
                    </button>
                </div>
            </form>
        </div>

        <div class="success-message" id="successMessage">
            <i class="fas fa-check-circle"></i>
            <h2 class="text-success mb-3">¡Solicitud Enviada Exitosamente!</h2>
            <p class="mb-3">Su solicitud ha sido recibida correctamente.</p>
            <div class="alert alert-info">
                <strong>Número de Solicitud:</strong> <span id="numeroSolicitud"></span>
            </div>
            <p>Recibirá un correo de confirmación con los detalles de su solicitud.</p>
            <p class="text-muted">El certificado será procesado y enviado a su correo electrónico 
               en un plazo máximo de 48 horas hábiles.</p>
            <button class="btn btn-primary mt-3" onclick="location.reload()">
                <i class="fas fa-plus me-2"></i>Nueva Solicitud
            </button>
        </div>

        <div class="footer-links">
            <a href="login.php"><i class="fas fa-sign-in-alt me-1"></i>Acceso Administrador</a>
            <a href="#"><i class="fas fa-question-circle me-1"></i>Ayuda</a>
        </div>

        <div class="text-center mt-4 text-white">
            <small>&copy; <?= date('Y') ?> Municipalidad de Loncoche. Todos los derechos reservados.</small>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="../assets/js/solicitud.js"></script>
</body>
</html>
