<?php
require_once '../../config/config.php';

$auth = new Auth();
$auth->requireLogin();

$user = $auth->getUser();
$solicitud = new Solicitud();

// Obtener filtros
$estado = $_GET['estado'] ?? '';
$busqueda = $_GET['busqueda'] ?? '';
$fecha_desde = $_GET['fecha_desde'] ?? '';
$fecha_hasta = $_GET['fecha_hasta'] ?? '';

// Obtener solicitudes
$filtros = [
    'estado' => $estado,
    'busqueda' => $busqueda,
    'fecha_desde' => $fecha_desde,
    'fecha_hasta' => $fecha_hasta
];

$solicitudes = $solicitud->obtenerTodas($filtros);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitudes - Panel de Administración</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="../../assets/css/admin.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/header.php'; ?>
    
    <div class="container-fluid">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                    <h1 class="h2">
                        <i class="fas fa-list me-2"></i>Solicitudes de Certificados
                    </h1>
                    <div class="btn-toolbar mb-2 mb-md-0">
                        <div class="btn-group me-2">
                            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="location.reload()">
                                <i class="fas fa-sync-alt me-1"></i>Actualizar
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-primary" onclick="exportarExcel()">
                                <i class="fas fa-file-excel me-1"></i>Exportar
                            </button>
                        </div>
                    </div>
                </div>

                <!-- Filtros -->
                <div class="card shadow mb-4">
                    <div class="card-header">
                        <i class="fas fa-filter me-2"></i>Filtros de Búsqueda
                    </div>
                    <div class="card-body">
                        <form method="GET" action="" class="row g-3">
                            <div class="col-md-3">
                                <label class="form-label">Estado:</label>
                                <select name="estado" class="form-select">
                                    <option value="">Todos</option>
                                    <option value="pendiente" <?= $estado === 'pendiente' ? 'selected' : '' ?>>Pendiente</option>
                                    <option value="en_proceso" <?= $estado === 'en_proceso' ? 'selected' : '' ?>>En Proceso</option>
                                    <option value="aprobada" <?= $estado === 'aprobada' ? 'selected' : '' ?>>Aprobada</option>
                                    <option value="rechazada" <?= $estado === 'rechazada' ? 'selected' : '' ?>>Rechazada</option>
                                    <option value="enviada" <?= $estado === 'enviada' ? 'selected' : '' ?>>Enviada</option>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label class="form-label">Búsqueda:</label>
                                <input type="text" name="busqueda" class="form-control" 
                                       placeholder="N° solicitud, nombre, RUT..." 
                                       value="<?= htmlspecialchars($busqueda) ?>">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">Fecha Desde:</label>
                                <input type="date" name="fecha_desde" class="form-control" 
                                       value="<?= htmlspecialchars($fecha_desde) ?>">
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">Fecha Hasta:</label>
                                <input type="date" name="fecha_hasta" class="form-control" 
                                       value="<?= htmlspecialchars($fecha_hasta) ?>">
                            </div>
                            <div class="col-md-2 d-flex align-items-end">
                                <button type="submit" class="btn btn-primary w-100">
                                    <i class="fas fa-search me-1"></i>Buscar
                                </button>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Tabla de Solicitudes -->
                <div class="card shadow mb-4">
                    <div class="card-header">
                        <h6 class="m-0 font-weight-bold text-primary">
                            <i class="fas fa-table me-2"></i>
                            Listado de Solicitudes (<?= count($solicitudes) ?>)
                        </h6>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover" id="solicitudesTable">
                                <thead>
                                    <tr>
                                        <th>N° Solicitud</th>
                                        <th>Fecha</th>
                                        <th>Nombre</th>
                                        <th>RUT</th>
                                        <th>Dirección</th>
                                        <th>Estado</th>
                                        <th>Adjuntos</th>
                                        <th>Acciones</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($solicitudes as $sol): ?>
                                    <tr>
                                        <td>
                                            <strong><?= htmlspecialchars($sol['numero_solicitud']) ?></strong>
                                        </td>
                                        <td><?= date('d/m/Y', strtotime($sol['fecha_solicitud'])) ?></td>
                                        <td><?= htmlspecialchars($sol['nombre_completo']) ?></td>
                                        <td><?= htmlspecialchars($sol['rut']) ?></td>
                                        <td>
                                            <small><?= htmlspecialchars(substr($sol['direccion'], 0, 40)) ?>...</small>
                                        </td>
                                        <td>
                                            <?php
                                            $badges = [
                                                'pendiente' => '<span class="badge bg-warning text-dark">Pendiente</span>',
                                                'en_proceso' => '<span class="badge bg-info">En Proceso</span>',
                                                'aprobada' => '<span class="badge bg-success">Aprobada</span>',
                                                'rechazada' => '<span class="badge bg-danger">Rechazada</span>',
                                                'enviada' => '<span class="badge bg-primary">Enviada</span>'
                                            ];
                                            echo $badges[$sol['estado']] ?? '<span class="badge bg-secondary">Desconocido</span>';
                                            ?>
                                        </td>
                                        <td class="text-center">
                                            <?php if ($sol['num_adjuntos'] > 0): ?>
                                            <span class="badge bg-info">
                                                <i class="fas fa-paperclip"></i> <?= $sol['num_adjuntos'] ?>
                                            </span>
                                            <?php else: ?>
                                            <span class="text-muted">-</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-group btn-group-sm" role="group">
                                                <a href="ver-solicitud.php?id=<?= $sol['id'] ?>" 
                                                   class="btn btn-info" title="Ver Detalles">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <?php if (!$sol['tiene_certificado']): ?>
                                                <button type="button" class="btn btn-success" 
                                                        onclick="generarCertificado(<?= $sol['id'] ?>)" 
                                                        title="Generar Certificado">
                                                    <i class="fas fa-file-pdf"></i>
                                                </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>
    <script src="../../assets/js/admin.js"></script>
    <script>
        $(document).ready(function() {
            $('#solicitudesTable').DataTable({
                language: {
                    url: '//cdn.datatables.net/plug-ins/1.13.6/i18n/es-ES.json'
                },
                order: [[1, 'desc']],
                pageLength: 25,
                responsive: true
            });
        });

        function exportarExcel() {
            window.location.href = '../api/exportar.php?tipo=solicitudes';
        }
    </script>
</body>
</html>
