<?php
// Obtener la página actual para marcar el menú activo
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<nav id="sidebarMenu" class="col-md-3 col-lg-2 d-md-block sidebar collapse">
    <div class="position-sticky sidebar-sticky pt-3">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?= $currentPage === 'dashboard.php' ? 'active' : '' ?>" 
                   href="dashboard.php">
                    <i class="fas fa-home"></i>
                    Dashboard
                </a>
            </li>
        </ul>

        <h6 class="sidebar-heading">
            <i class="fas fa-folder me-2"></i>Gestión de Solicitudes
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?= $currentPage === 'solicitudes.php' ? 'active' : '' ?>" 
                   href="solicitudes.php">
                    <i class="fas fa-list"></i>
                    Todas las Solicitudes
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="solicitudes.php?estado=pendiente">
                    <i class="fas fa-clock"></i>
                    Pendientes
                    <span class="badge bg-warning ms-auto" id="badge-pendientes">0</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="solicitudes.php?estado=en_proceso">
                    <i class="fas fa-spinner"></i>
                    En Proceso
                    <span class="badge bg-info ms-auto" id="badge-proceso">0</span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="solicitudes.php?estado=aprobada">
                    <i class="fas fa-check-circle"></i>
                    Aprobadas
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="solicitudes.php?estado=enviada">
                    <i class="fas fa-paper-plane"></i>
                    Enviadas
                </a>
            </li>
        </ul>

        <h6 class="sidebar-heading">
            <i class="fas fa-certificate me-2"></i>Certificados
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?= $currentPage === 'certificados.php' ? 'active' : '' ?>" 
                   href="certificados.php">
                    <i class="fas fa-file-pdf"></i>
                    Todos los Certificados
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="certificados.php?firmados=0">
                    <i class="fas fa-file-signature"></i>
                    Pendientes de Firma
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="certificados.php?firmados=1">
                    <i class="fas fa-check-double"></i>
                    Firmados
                </a>
            </li>
        </ul>

        <h6 class="sidebar-heading">
            <i class="fas fa-chart-bar me-2"></i>Reportes
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?= $currentPage === 'estadisticas.php' ? 'active' : '' ?>" 
                   href="estadisticas.php">
                    <i class="fas fa-chart-line"></i>
                    Estadísticas
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $currentPage === 'logs.php' ? 'active' : '' ?>" 
                   href="logs.php">
                    <i class="fas fa-history"></i>
                    Registro de Actividad
                </a>
            </li>
        </ul>

        <h6 class="sidebar-heading">
            <i class="fas fa-cog me-2"></i>Sistema
        </h6>
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?= $currentPage === 'usuarios.php' ? 'active' : '' ?>" 
                   href="usuarios.php">
                    <i class="fas fa-users"></i>
                    Usuarios
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?= $currentPage === 'configuracion.php' ? 'active' : '' ?>" 
                   href="configuracion.php">
                    <i class="fas fa-sliders-h"></i>
                    Configuración
                </a>
            </li>
        </ul>

        <hr class="my-3">

        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link text-muted" href="../index.php" target="_blank">
                    <i class="fas fa-external-link-alt"></i>
                    Ver Formulario Público
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link text-danger" href="logout.php">
                    <i class="fas fa-sign-out-alt"></i>
                    Cerrar Sesión
                </a>
            </li>
        </ul>

        <!-- Información del Sistema -->
        <div class="mt-4 p-3 bg-light rounded">
            <small class="text-muted d-block mb-2">
                <i class="fas fa-user-circle me-1"></i>
                <strong><?= htmlspecialchars($user['nombre_completo']) ?></strong>
            </small>
            <small class="text-muted d-block">
                <i class="fas fa-clock me-1"></i>
                <?= date('d/m/Y H:i') ?>
            </small>
        </div>
    </div>
</nav>

<style>
.sidebar {
    position: fixed;
    top: 56px;
    bottom: 0;
    left: 0;
    z-index: 100;
    padding: 0;
    box-shadow: inset -1px 0 0 rgba(0, 0, 0, .1);
    background-color: #212529;
    overflow-x: hidden;
    overflow-y: auto;
}

.sidebar-sticky {
    height: calc(100vh - 56px);
    overflow-x: hidden;
    overflow-y: auto;
}

.sidebar .nav-link {
    font-weight: 500;
    color: rgba(255, 255, 255, 0.7);
    padding: 12px 20px;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.sidebar .nav-link:hover {
    color: #fff;
    background-color: rgba(255, 255, 255, 0.1);
}

.sidebar .nav-link.active {
    color: #fff;
    background-color: #0066cc;
    border-left: 4px solid #fff;
}

.sidebar .nav-link i {
    margin-right: 10px;
    width: 20px;
    text-align: center;
}

.sidebar-heading {
    font-size: 0.75rem;
    text-transform: uppercase;
    color: rgba(255, 255, 255, 0.5);
    padding: 12px 20px;
    margin-top: 15px;
    font-weight: 600;
}

.sidebar .badge {
    font-size: 0.7rem;
    padding: 3px 6px;
}

/* Scrollbar personalizado para sidebar */
.sidebar-sticky::-webkit-scrollbar {
    width: 6px;
}

.sidebar-sticky::-webkit-scrollbar-track {
    background: rgba(255, 255, 255, 0.1);
}

.sidebar-sticky::-webkit-scrollbar-thumb {
    background: rgba(255, 255, 255, 0.3);
    border-radius: 3px;
}

.sidebar-sticky::-webkit-scrollbar-thumb:hover {
    background: rgba(255, 255, 255, 0.5);
}

/* Responsive */
@media (max-width: 767.98px) {
    .sidebar {
        position: relative;
        top: 0;
    }
    
    .sidebar-sticky {
        height: auto;
    }
}
</style>

<script>
// Actualizar badges con contadores
function actualizarBadges() {
    $.ajax({
        url: '../api/solicitudes.php',
        type: 'GET',
        success: function(response) {
            if (response.success) {
                let pendientes = 0;
                let enProceso = 0;
                
                response.data.forEach(function(sol) {
                    if (sol.estado === 'pendiente') pendientes++;
                    if (sol.estado === 'en_proceso') enProceso++;
                });
                
                if (pendientes > 0) {
                    $('#badge-pendientes').text(pendientes).show();
                } else {
                    $('#badge-pendientes').hide();
                }
                
                if (enProceso > 0) {
                    $('#badge-proceso').text(enProceso).show();
                } else {
                    $('#badge-proceso').hide();
                }
            }
        }
    });
}

$(document).ready(function() {
    actualizarBadges();
    // Actualizar cada 30 segundos
    setInterval(actualizarBadges, 30000);
});
</script>
