<?php
// Asegurar que estamos autenticados
if (!isset($auth) || !$auth->isLoggedIn()) {
    header('Location: ../login.php');
    exit;
}

$user = $auth->getUser();
?>
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm fixed-top">
    <div class="container-fluid">
        <a class="navbar-brand d-flex align-items-center" href="dashboard.php">
            <i class="fas fa-home-lg-alt fa-2x text-primary me-2"></i>
            <div>
                <strong class="d-block">Municipalidad de Loncoche</strong>
                <small class="text-muted">Sistema de Certificados</small>
            </div>
        </a>
        
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                <!-- Notificaciones -->
                <li class="nav-item dropdown me-3">
                    <a class="nav-link position-relative" href="#" id="notificacionesDropdown" 
                       role="button" data-bs-toggle="dropdown">
                        <i class="fas fa-bell fa-lg"></i>
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger" 
                              id="notificacionesBadge" style="display: none;">
                            0
                        </span>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end" style="min-width: 300px;">
                        <li><h6 class="dropdown-header">Notificaciones</h6></li>
                        <li><hr class="dropdown-divider"></li>
                        <li id="notificacionesLista">
                            <div class="text-center p-3 text-muted">
                                <i class="fas fa-inbox fa-2x mb-2"></i>
                                <p class="mb-0">No hay notificaciones</p>
                            </div>
                        </li>
                    </ul>
                </li>
                
                <!-- Usuario -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle d-flex align-items-center" href="#" 
                       id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                        <div class="avatar-circle bg-primary text-white me-2">
                            <?= strtoupper(substr($user['nombre_completo'], 0, 1)) ?>
                        </div>
                        <div class="d-none d-md-block text-start">
                            <small class="d-block"><?= htmlspecialchars($user['nombre_completo']) ?></small>
                            <small class="text-muted"><?= htmlspecialchars($user['cargo']) ?></small>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="fas fa-user me-2"></i>Mi Perfil
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item" href="#">
                                <i class="fas fa-cog me-2"></i>Configuración
                            </a>
                        </li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <a class="dropdown-item text-danger" href="logout.php">
                                <i class="fas fa-sign-out-alt me-2"></i>Cerrar Sesión
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>

<style>
.navbar {
    z-index: 1000;
}

.avatar-circle {
    width: 40px;
    height: 40px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    font-size: 18px;
}

.navbar-brand {
    font-size: 14px;
}

.navbar-brand strong {
    font-size: 16px;
    color: #0066cc;
}

.nav-link {
    color: #6c757d !important;
    transition: color 0.3s;
}

.nav-link:hover {
    color: #0066cc !important;
}

.dropdown-item {
    transition: all 0.3s;
}

.dropdown-item:hover {
    background-color: #f8f9fa;
    padding-left: 20px;
}

@media (max-width: 768px) {
    .navbar-brand div {
        display: none;
    }
    
    .navbar-brand i {
        margin-right: 0 !important;
    }
}
</style>

<script>
// Cargar notificaciones
function cargarNotificaciones() {
    $.ajax({
        url: '../api/notificaciones.php',
        type: 'GET',
        success: function(response) {
            if (response.success && response.data.length > 0) {
                $('#notificacionesBadge').text(response.data.length).show();
                
                let html = '';
                response.data.forEach(function(notif) {
                    html += `
                        <li>
                            <a class="dropdown-item" href="${notif.url}">
                                <i class="fas ${notif.icon} me-2"></i>
                                <small>${notif.mensaje}</small>
                            </a>
                        </li>
                    `;
                });
                
                $('#notificacionesLista').html(html);
            }
        }
    });
}

// Cargar notificaciones cada 30 segundos
$(document).ready(function() {
    cargarNotificaciones();
    setInterval(cargarNotificaciones, 30000);
});
</script>
