<?php
/**
 * Script para generar hash de contraseña y actualizar usuario admin
 * Ejecutar una sola vez desde la línea de comandos o navegador
 */

// Configuración de conexión a la base de datos
$host = 'localhost';
$dbname = 'certificados_residencia';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Nueva contraseña (cambiar según necesidad)
    $nueva_password = 'admin123';
    
    // Generar hash correcto
    $hash = password_hash($nueva_password, PASSWORD_BCRYPT, ['cost' => 10]);
    
    echo "Hash generado: $hash\n";
    echo "Contraseña: $nueva_password\n\n";
    
    // Actualizar usuario admin
    $stmt = $pdo->prepare("UPDATE usuarios SET password = ? WHERE username = 'admin'");
    $stmt->execute([$hash]);
    
    echo "✓ Contraseña actualizada exitosamente\n";
    echo "Usuario: admin\n";
    echo "Contraseña: $nueva_password\n";
    
    // Verificar que funciona
    $stmt = $pdo->prepare("SELECT * FROM usuarios WHERE username = 'admin'");
    $stmt->execute();
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user && password_verify($nueva_password, $user['password'])) {
        echo "\n✓✓✓ VERIFICACIÓN EXITOSA - El login funcionará correctamente\n";
    } else {
        echo "\n✗ ERROR - Verificación fallida\n";
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
