# 🔧 Solución: Error al Comunicarse con el Servidor

## 🐛 PROBLEMA

Al intentar generar y firmar certificado aparece:
```
Error al comunicarse con el servidor
```

---

## 🔍 DIAGNÓSTICO RÁPIDO

### Paso 1: Ejecutar diagnóstico

1. Abrir en navegador:
   ```
   http://localhost/certificados-residencia/public/diagnostico.php
   ```

2. Revisar todos los checks:
   - ✅ Verde = OK
   - ⚠️ Amarillo = Advertencia
   - ❌ Rojo = Error (hay que corregir)

### Paso 2: Revisar logs

**En el navegador:**
1. Presionar F12
2. Ir a "Console" (Consola)
3. Intentar generar certificado
4. Ver errores en rojo

**En el servidor:**
```bash
# Ver últimos errores
tail -50 /var/log/apache2/error.log
# o
tail -50 /var/log/php_errors.log
```

---

## ✅ SOLUCIONES COMUNES

### Solución 1: Permisos de Directorios

```bash
# Ir al directorio del proyecto
cd certificados-residencia

# Crear directorios necesarios
mkdir -p uploads/solicitudes
mkdir -p uploads/certificados
mkdir -p certificates
mkdir -p logs

# Dar permisos
chmod -R 755 uploads/
chmod -R 755 certificates/
chmod -R 755 logs/

# En algunos casos necesitas 777 (menos seguro)
chmod -R 777 uploads/
chmod -R 777 certificates/
```

### Solución 2: Instalar Dependencias

```bash
# Instalar Composer si no está instalado
# En Ubuntu/Debian:
sudo apt-get install composer

# Instalar dependencias del proyecto
cd certificados-residencia
composer install

# O instalar solo lo necesario
composer require tecnickcom/tcpdf
composer require dompdf/dompdf
```

### Solución 3: Configuración de PHP

**Archivo: php.ini**

```ini
; Permitir uploads
file_uploads = On

; Tamaño máximo de archivo (10MB)
upload_max_filesize = 10M
post_max_size = 10M

; Tiempo de ejecución (60 segundos)
max_execution_time = 60

; Memoria (256MB)
memory_limit = 256M

; Mostrar errores (solo desarrollo)
display_errors = On
error_reporting = E_ALL

; Log de errores
log_errors = On
error_log = /var/log/php_errors.log
```

**Reiniciar servidor:**
```bash
# Apache
sudo service apache2 restart

# Nginx + PHP-FPM
sudo service nginx restart
sudo service php7.4-fpm restart  # Ajustar versión
```

### Solución 4: Extensiones PHP

```bash
# Verificar extensiones instaladas
php -m | grep -E "openssl|mysqli|gd|mbstring"

# Si falta alguna, instalar:
# Ubuntu/Debian
sudo apt-get install php-openssl php-mysqli php-gd php-mbstring

# Reiniciar servidor
sudo service apache2 restart
```

### Solución 5: Base de Datos

```bash
# Conectar a MySQL
mysql -u root -p

# Ejecutar schema
USE certificados_residencia;
SOURCE /ruta/a/certificados-residencia/database/schema.sql;

# Verificar tabla de certificados
DESCRIBE certificados;

# Salir
exit;
```

### Solución 6: Archivo .htaccess

**Verificar que existe:** `public/.htaccess`

```apache
RewriteEngine On
RewriteBase /certificados-residencia/public/

# Permitir acceso a archivos estáticos
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d

# No tocar si existe
```

### Solución 7: Configuración de config.php

**Archivo: config/config.php**

Verificar que las rutas sean correctas:

```php
// Base de datos
define('DB_HOST', 'localhost');
define('DB_NAME', 'certificados_residencia');
define('DB_USER', 'root');
define('DB_PASS', '');  // Tu contraseña

// URL de la aplicación
define('APP_URL', 'http://localhost/certificados-residencia');
```

---

## 🧪 PRUEBAS PASO A PASO

### Test 1: Generar SIN firma

1. Login: admin / admin123
2. Ver solicitud
3. Click "Generar Certificado"
4. **NO activar** firma automática
5. Click "Generar Certificado"

**Resultado esperado:**
- ✅ "Certificado generado exitosamente"
- ✅ PDF descargable

**Si falla:**
- Ver logs en F12 > Console
- Verificar permisos de uploads/certificados/

### Test 2: Generar CON firma

1. Click "Generar Certificado"
2. ✅ Activar "Generar y firmar automáticamente"
3. Seleccionar archivo .pfx
4. Escribir contraseña
5. Click "Generar y Firmar Certificado"

**Resultado esperado:**
- ✅ "Certificado generado y firmado exitosamente"
- ✅ PDF con firma visible

**Si falla aquí pero Test 1 funciona:**
- Problema con certificado .pfx o contraseña
- Verificar extensión OpenSSL de PHP
- Ver error exacto en logs

---

## 📋 CHECKLIST DE VERIFICACIÓN

Marca cada uno al completarlo:

### Directorios:
- [ ] uploads/ existe y tiene permisos 755 o 777
- [ ] uploads/certificados/ existe
- [ ] uploads/solicitudes/ existe
- [ ] certificates/ existe y tiene permisos 755 o 777
- [ ] logs/ existe

### PHP:
- [ ] Versión PHP >= 7.4
- [ ] Extensión openssl instalada
- [ ] Extensión mysqli instalada
- [ ] Extensión gd instalada
- [ ] file_uploads = On
- [ ] upload_max_filesize >= 10M
- [ ] post_max_size >= 10M

### Composer:
- [ ] vendor/autoload.php existe
- [ ] TCPDF instalado (vendor/tecnickcom/tcpdf)
- [ ] Dompdf instalado (opcional)

### Base de Datos:
- [ ] MySQL funcionando
- [ ] Base de datos 'certificados_residencia' existe
- [ ] Tabla 'certificados' existe
- [ ] Usuario admin existe

### Configuración:
- [ ] config/config.php tiene credenciales correctas
- [ ] APP_URL es correcta
- [ ] Rutas BASE_PATH correctas

---

## 🔬 ERRORES ESPECÍFICOS

### Error: "Class 'TCPDF' not found"

```bash
composer require tecnickcom/tcpdf
```

### Error: "Call to undefined function openssl_pkcs12_read()"

```bash
# Ubuntu/Debian
sudo apt-get install php-openssl
sudo service apache2 restart
```

### Error: "Permission denied"

```bash
chmod -R 777 uploads/
chmod -R 777 certificates/
```

### Error: "Failed to open stream"

```bash
# Verificar que el directorio existe
ls -la uploads/certificados/

# Crearlo si no existe
mkdir -p uploads/certificados
chmod 777 uploads/certificados
```

### Error: "Cannot modify header information"

Hay un echo o espacio antes del `<?php` en algún archivo.

Buscar:
```bash
grep -r "^[[:space:]]*$\|^[^<?]" --include="*.php" .
```

### Error: "SQLSTATE[HY000] [2002] Connection refused"

MySQL no está corriendo:
```bash
sudo service mysql start
```

---

## 💡 TIPS ADICIONALES

### Habilitar modo debug:

**En config.php:**
```php
// Al inicio del archivo
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
```

### Ver TODOS los errores PHP:

```bash
# Ver log en tiempo real
tail -f /var/log/apache2/error.log
```

### Test rápido de PHP:

Crear archivo: `test.php`
```php
<?php
phpinfo();
?>
```

Abrir: `http://localhost/certificados-residencia/public/test.php`

Buscar:
- openssl
- mysqli
- gd
- upload_max_filesize
- post_max_size

### Limpiar caché:

```bash
# Borrar archivos temporales
rm -rf certificates/temp_cert_*
```

---

## 📞 SI NADA FUNCIONA

### Opción 1: Reinstalación limpia

```bash
# Backup de base de datos
mysqldump -u root -p certificados_residencia > backup.sql

# Borrar vendor
rm -rf vendor/

# Reinstalar
composer install

# Permisos
chmod -R 777 uploads/ certificates/

# Restaurar BD si es necesario
mysql -u root -p certificados_residencia < backup.sql
```

### Opción 2: Revisar con diagnóstico

1. Ir a: `/public/diagnostico.php`
2. Capturar pantalla de TODOS los errores rojos
3. Seguir las soluciones sugeridas una por una

### Opción 3: Logs detallados

Agregar al inicio de `public/api/certificados.php`:

```php
error_log("=== REQUEST RECIBIDO ===");
error_log("POST: " . print_r($_POST, true));
error_log("FILES: " . print_r($_FILES, true));
error_log("========================");
```

Luego revisar logs después de intentar generar.

---

## ✅ SOLUCIÓN DEFINITIVA

Si después de seguir todos los pasos anteriores aún hay error:

1. Ejecutar diagnóstico
2. Copiar TODOS los errores rojos
3. Revisar los logs
4. Verificar que:
   - Base de datos funciona
   - Permisos correctos
   - TCPDF instalado
   - OpenSSL habilitado

El error "Error al comunicarse con el servidor" es genérico.

El error REAL está en:
- Consola del navegador (F12)
- Logs de PHP
- Logs de Apache

**Encuentra el error real y aplica la solución correspondiente.**

---

**Última actualización:** 27 de Diciembre, 2025  
**Para soporte:** Revisar documentación técnica completa
