# Sistema de Certificados de Residencia Digital

Sistema web completo para gestionar solicitudes, generar y firmar digitalmente certificados de residencia en PDF.

## 🚀 Características

- ✅ Formulario público para solicitudes de certificados
- ✅ Validación de RUT chileno
- ✅ Carga de documentos adjuntos (PDF, JPG, PNG)
- ✅ Protección con Google reCAPTCHA
- ✅ Panel de administración completo
- ✅ Generación automática de certificados en PDF
- ✅ Firma digital de certificados (DSC/PFX)
- ✅ Envío automático por correo electrónico
- ✅ Sistema de logs y auditoría
- ✅ Dashboard con estadísticas
- ✅ Diseño responsive con Bootstrap 5

## 📋 Requisitos del Sistema

- PHP 8.0 o superior
- MySQL 5.7 o superior
- Servidor web (Apache/Nginx)
- Composer
- Extensiones PHP requeridas:
  - pdo_mysql
  - mbstring
  - openssl
  - fileinfo
  - gd
  - zip

## 🔧 Instalación

### 1. Clonar o descargar el proyecto

```bash
cd /var/www/html
git clone [URL_DEL_REPOSITORIO] certificados-residencia
cd certificados-residencia
```

### 2. Instalar dependencias con Composer

```bash
composer install
```

### 3. Configurar la base de datos

```bash
# Crear la base de datos
mysql -u root -p < database/schema.sql
```

### 4. Configurar el archivo de configuración

Editar `config/config.php` y ajustar los siguientes parámetros:

```php
// Configuración de la base de datos
define('DB_HOST', 'localhost');
define('DB_NAME', 'certificados_residencia');
define('DB_USER', 'tu_usuario');
define('DB_PASS', 'tu_contraseña');

// URL de la aplicación
define('APP_URL', 'http://tu-dominio.com/certificados-residencia');
```

### 5. Configurar permisos de directorios

```bash
chmod -R 755 uploads/
chmod -R 755 certificates/
chmod -R 777 uploads/solicitudes/
chmod -R 777 uploads/certificados/
```

### 6. Configurar SMTP para envío de correos

Acceder al sistema con las credenciales por defecto y configurar SMTP en:
**Panel Admin > Configuración > Email**

O directamente en la base de datos:

```sql
UPDATE configuracion SET valor = 'smtp.gmail.com' WHERE clave = 'smtp_host';
UPDATE configuracion SET valor = '587' WHERE clave = 'smtp_port';
UPDATE configuracion SET valor = 'tu_email@gmail.com' WHERE clave = 'smtp_user';
UPDATE configuracion SET valor = 'tu_contraseña_app' WHERE clave = 'smtp_password';
```

### 7. Configurar Google reCAPTCHA

1. Obtener claves en: https://www.google.com/recaptcha/admin
2. Actualizar en la base de datos:

```sql
UPDATE configuracion SET valor = 'TU_SITE_KEY' WHERE clave = 'captcha_site_key';
UPDATE configuracion SET valor = 'TU_SECRET_KEY' WHERE clave = 'captcha_secret_key';
```

## 👤 Acceso al Sistema

### Usuario Administrador por Defecto

- **Usuario:** admin
- **Contraseña:** admin123

**⚠️ IMPORTANTE:** Cambiar la contraseña inmediatamente después del primer acceso.

### URLs del Sistema

- **Formulario público:** `http://tu-dominio.com/certificados-residencia/public/`
- **Panel de administración:** `http://tu-dominio.com/certificados-residencia/public/login.php`

## 📖 Guía de Uso

### Para Vecinos

1. Acceder al formulario público
2. Completar todos los campos requeridos
3. Adjuntar documentos de respaldo (opcional)
4. Completar el reCAPTCHA
5. Enviar la solicitud
6. Recibirá un correo de confirmación con el número de solicitud

### Para Administradores

#### Gestionar Solicitudes

1. Iniciar sesión en el panel de administración
2. Ver lista de solicitudes en **Solicitudes > Ver Todas**
3. Hacer clic en una solicitud para ver detalles
4. Cambiar estado según corresponda

#### Generar Certificados

1. Abrir una solicitud aprobada
2. Hacer clic en **Generar Certificado**
3. El PDF se generará automáticamente
4. Descargar o firmar el certificado

#### Firmar Certificados

1. Abrir un certificado generado
2. Hacer clic en **Firmar Certificado**
3. Subir archivo de certificado digital (.pfx o .p12)
4. Ingresar contraseña del certificado
5. Confirmar firma

#### Enviar Certificados

1. Abrir un certificado (firmado o sin firmar)
2. Hacer clic en **Enviar por Correo**
3. El certificado se enviará al email del solicitante
4. El estado cambiará a "Enviada"

## 🗂️ Estructura del Proyecto

```
certificados-residencia/
├── config/
│   └── config.php              # Configuración principal
├── database/
│   └── schema.sql              # Esquema de base de datos
├── src/
│   ├── Database.php            # Clase de conexión DB
│   ├── Auth.php                # Autenticación
│   ├── Solicitud.php           # Gestión de solicitudes
│   ├── CertificadoPDF.php      # Generación de PDFs
│   └── Mailer.php              # Envío de correos
├── public/
│   ├── index.php               # Formulario público
│   ├── login.php               # Login administrador
│   ├── admin/
│   │   ├── dashboard.php       # Panel principal
│   │   ├── solicitudes.php     # Lista de solicitudes
│   │   └── ver-solicitud.php   # Ver detalle
│   └── api/
│       ├── solicitudes.php     # API solicitudes
│       └── certificados.php    # API certificados
├── assets/
│   ├── css/
│   ├── js/
│   └── images/
├── uploads/
│   ├── solicitudes/            # Archivos adjuntos
│   └── certificados/           # PDFs generados
├── certificates/               # Certificados digitales
├── composer.json
└── README.md
```

## 🔐 Seguridad

- Autenticación con sesiones seguras
- Protección CSRF en formularios
- Validación de datos en cliente y servidor
- Protección contra SQL Injection (PDO)
- Protección contra XSS
- Encriptación de contraseñas (bcrypt)
- Validación de archivos adjuntos
- Límite de tamaño de archivos
- Google reCAPTCHA contra bots

## 🔑 Certificados Digitales

### Formatos Soportados

- .pfx (PKCS#12)
- .p12 (PKCS#12)

### Obtener un Certificado Digital

En Chile, puede obtener certificados digitales de:
- Gobierno de Chile: https://www.claveunica.gob.cl
- E-Certchile
- Otras entidades certificadoras acreditadas

### Configurar Firma Digital

1. Obtener certificado digital (.pfx)
2. Guardar en directorio `certificates/`
3. Al firmar, subir el archivo y contraseña

## 📧 Configuración de Correo

### Gmail

```sql
UPDATE configuracion SET valor = 'smtp.gmail.com' WHERE clave = 'smtp_host';
UPDATE configuracion SET valor = '587' WHERE clave = 'smtp_port';
UPDATE configuracion SET valor = 'tls' WHERE clave = 'smtp_secure';
```

**Nota:** Necesita crear una "Contraseña de aplicación" en su cuenta de Google.

### Otros Proveedores

Configurar según los parámetros SMTP de su proveedor de correo.

## 🐛 Solución de Problemas

### Error al enviar correos

- Verificar configuración SMTP
- Comprobar firewall/puerto 587
- Verificar credenciales de correo

### Error al generar PDF

- Verificar permisos de escritura en `uploads/certificados/`
- Comprobar instalación de extensión `mbstring`

### Error al cargar archivos

- Verificar permisos en `uploads/solicitudes/`
- Comprobar `upload_max_filesize` en php.ini
- Verificar `post_max_size` en php.ini

### Sesión expirada constantemente

- Ajustar `SESSION_LIFETIME` en `config/config.php`
- Verificar configuración de sesiones en php.ini

## 📝 Notas Adicionales

### Personalización

- Logos y colores: Editar archivos CSS en `assets/css/`
- Texto de certificados: Editar `src/CertificadoPDF.php`
- Emails: Editar templates en `src/Mailer.php`

### Backup

Realizar backups regulares de:
- Base de datos MySQL
- Directorio `uploads/`
- Directorio `certificates/`

### Actualizaciones

```bash
composer update
```

## 📄 Licencia

Este proyecto está bajo la Licencia MIT.

## 👨‍💻 Soporte

Para soporte técnico o consultas:
- Email: soporte@ejemplo.com
- Teléfono: +56 45 2491100

---

**Desarrollado para Municipalidad de Loncoche**
© 2025 Todos los derechos reservados
